<?php


namespace WPML\Languages;

use WPML\Core\WP\App\Resources;
use WPML\Element\API\Languages;
use WPML\LIB\WP\Hooks;
use WPML\Setup\Option;
use WPML\TM\ATE\AutoTranslate\Endpoint\GetNumberOfPosts;
use WPML\UIPage;

class UI implements \IWPML_Backend_Action {

	public function add_hooks() {
		if ( UIPage::isLanguages( $_GET ) ) {

			Hooks::onAction( 'admin_enqueue_scripts' )
			     ->then( [ self::class, 'getData' ] )
			     ->then( Resources::enqueueApp( 'languages' ) );
		}
	}

	public static function getData() {
		return [
			'name' => 'wpmlLanguagesUI',
			'data' => [
				'endpoints'                 => [
					'getCount' => GetNumberOfPosts::class,
				],
				'shouldTranslateEverything' => Option::shouldTranslateEverything(),
				'existingLangs'             => Languages::getSecondaryCodes(),
				'defaultLang'               => Languages::getDefaultCode(),
				'settingsUrl'               => admin_url( UIPage::getSettings() ),
			]

		];
	}
}
