<?php

namespace OTGS\Installer\SiteKey;

class SiteKeyUrlStorage {
	const INSTALLER_NOTICE_STATE_STORAGE_OPTION = 'otgs_installer_site_url_notice_state';

	const STATE_SITE_MOVED = 'move';
	const STATE_SITE_MOVED_PRODUCTION = 2;
	const STATE_SITE_MOVED_STAY_DEV = 3;
	const STATE_SITE_COPIED = 'copy';

	public static function getState() {
		return get_option( self::INSTALLER_NOTICE_STATE_STORAGE_OPTION, [] );
	}

	public static function updateState( $repositoryId, $newState ) {
		if ( self::validateState( $newState ) ) {
			$state = get_option( self::INSTALLER_NOTICE_STATE_STORAGE_OPTION, [] );
			$state[ $repositoryId ] = $newState;
			update_option(
				self::INSTALLER_NOTICE_STATE_STORAGE_OPTION,
				$state,
				'no'
			);
		}
	}

	private static function validateState( $state ) {
		return in_array( $state, [
			self::STATE_SITE_MOVED,
			self::STATE_SITE_MOVED_PRODUCTION,
			self::STATE_SITE_MOVED_STAY_DEV,
			self::STATE_SITE_COPIED,
		] );
	}

}
