<?php

namespace OTGS\Installer\SiteKey;

use WP_Installer;

class SiteUrlWatcher {

	/**
	 * @var WP_Installer
	 */
	private $installer;

	public function __construct( WP_Installer $installer ) {
		$this->installer = $installer;
	}

	public function hasSiteUrlChanged( $repositoryId ) {
		$urlChanged = false;

		$storedUrl     = $this->installer->get_stored_site_url( $repositoryId );
		$actualSiteUrl = $this->installer->get_installer_site_url( $repositoryId );
		if ( $storedUrl ) {
			if ( $storedUrl != $actualSiteUrl ) {
				$urlChanged = true;
			}
		} else {
			$this->installer->store_site_url( $repositoryId, $actualSiteUrl );
		}

		return $urlChanged;
	}
}
