var otgs_wp_installer_site_url_changed = {
    init: function () {
        jQuery('.otgs_siteurl_changed_type').click(otgs_wp_installer_site_url_changed.siteurl_changed_action)
        jQuery('.otgs_siteurl_should_site_stay_dev_action').click(otgs_wp_installer_site_url_changed.otgs_siteurl_should_site_stay_dev_action)
        jQuery('.otgs_siteurl_copied_action').click(otgs_wp_installer_site_url_changed.otgs_siteurl_copied_action)
    },

    siteurl_changed_action: function () {
        var button = jQuery(this),
            actionSelection = button.closest('.otgs-site-url-changed-action-selection'),
            noticeElement = actionSelection.closest('.site-key-notice'),
            changedOption = noticeElement.find('input[name*="otgs_siteurl_option"]:checked').val()

        actionSelection.hide()
        if (changedOption === 'move') {
            noticeElement.find('.otgs-site-url-moved-selection').show()
            otgs_wp_installer_site_url_changed.storeState(noticeElement, 'move')
        } else {
            noticeElement.find('.otgs-site-url-copied-selection').show()
            otgs_wp_installer_site_url_changed.storeState(noticeElement, 'copy')
        }
    },

    otgs_siteurl_should_site_stay_dev_action: function () {
        var button = jQuery(this),
            actionSelection = button.closest('.otgs-site-url-moved-selection'),
            noticeElement = actionSelection.closest('.site-key-notice'),
            changedOption = noticeElement.find('input[name*="otgs_siteurl_should_site_stay_dev"]:checked').val()

        actionSelection.hide()

        if (changedOption === 'no') {
            noticeElement.find('.otgs-site-url-moved-selection_no').show()
            otgs_wp_installer_site_url_changed.storeState(noticeElement, 2) // 1 is "Moved to production"
        } else {
            noticeElement.find('.otgs-site-url-moved-selection_yes').show()
            otgs_wp_installer_site_url_changed.storeState(noticeElement, 3) // 1 is "Moved, stay as dev"
        }
    },

    otgs_siteurl_copied_action: function () {
        var button = jQuery(this),
            actionSelection = button.closest('.otgs-site-key-notice__actions'),
            noticeElement = actionSelection.closest('.site-key-notice'),
            repositoryId = noticeElement.find('#repositoryId').val(),
            nonce = actionSelection.find('#save_site_key_' + repositoryId).val(),
            siteKey = actionSelection.find('#site_key_' + repositoryId).val(),
            errorBox = actionSelection.find('.installer-error-box'),
            spinner = actionSelection.find('.spinner')

        button.prop('disabled', true)
        spinner.css({visibility: 'visible', float: 'none'})

        jQuery.ajax({
            url: ajaxurl,
            type: 'POST',
            data: {
                action: 'save_site_key',
                nonce: nonce,
                repository_id: repositoryId,
                ['site_key_' + repositoryId]: siteKey,
            },
            success:
                function (ret) {
                    if (!ret.data.error) {
                        location.reload();
                    } else {
                        errorBox.html(ret.data.error).show()
                        button.prop('disabled', false)
                    }
                    spinner.remove()
                }
        });
    },

    storeState: function (noticeElement, state) {
        var repositoryId = noticeElement.find('#repositoryId').val(),
            nonce = noticeElement.find('#site_key_changed_action_nonce').val()

        jQuery.ajax({
            url: ajaxurl,
            type: 'POST',
            data: {
                action: 'installer_site_key_changed_action',
                nonce: nonce,
                repositoryId: repositoryId,
                state: state
            }
        })
    }
}

jQuery(document).ready(otgs_wp_installer_site_url_changed.init)
