<?php

namespace WPML\TM\ATE\AutoTranslate\Endpoint;

use WPML\Ajax\IHandler;
use WPML\Collect\Support\Collection;
use WPML\FP\Left;
use WPML\FP\Right;

class AutoTranslate implements IHandler {

	public function run( Collection $data ) {
		global $wpml_translation_job_factory;

		$trid          = $data->get( 'trid' );
		$language_code = $data->get( 'language' );

		if ( $trid && $language_code ) {
			$post_id = \SitePress::get_original_element_id_by_trid( $trid );

			return Right::of( [
				'jobId' => $wpml_translation_job_factory->create_local_post_job(
					$post_id,
					$language_code
				)
			] );
		}

		return Left::of( 'invalid data' );
	}

}
