<?php

use function WPML\FP\invoke;

class WPML_TM_ATE_Job_Repository {

	/** @var WPML_TM_Jobs_Repository */
	private $job_repository;

	public function __construct( WPML_TM_Jobs_Repository $job_repository ) {
		$this->job_repository  = $job_repository;
	}

	/**
	 * @return WPML_TM_Jobs_Collection
	 */
	public function get_jobs_to_sync() {
		$searchParams = $this->getSearchParamsPrototype();
		$searchParams->set_status( [ ICL_TM_WAITING_FOR_TRANSLATOR, ICL_TM_IN_PROGRESS ] );

		return $this->job_repository
			->get( $searchParams )
			->filter( invoke( 'is_ate_job' ) );
	}

	/**
	 * @return WPML_TM_Jobs_Collection
	 */
	public function get_jobs_to_retry() {
		$searchParams = $this->getSearchParamsPrototype();
		$searchParams->set_status( [ ICL_TM_ATE_NEEDS_RETRY ] );

		return $this->job_repository
			->get( $searchParams )
			->filter( invoke( 'is_ate_job' ) );
	}

	/**
	 * @return WPML_TM_Jobs_Search_Params
	 */
	private function getSearchParamsPrototype() {
		$searchParams = new WPML_TM_Jobs_Search_Params();
		$searchParams->set_scope( WPML_TM_Jobs_Search_Params::SCOPE_LOCAL );
		$searchParams->set_job_types( [
			WPML_TM_Job_Entity::POST_TYPE,
			WPML_TM_Job_Entity::PACKAGE_TYPE,
			WPML_TM_Job_Entity::STRING_BATCH,
		] );

		return $searchParams;
	}
}
