/* globals ajaxurl */

import Tools from "../settings/UI/Shared/Tools";

class TranslationEditorClassic {
    constructor() {
        this.ajaxUrl = ajaxurl;
        this.tools = new Tools();
    }

    init() {
        this.mainNotice = document.querySelector('.js-classic-editor-notice');
        if (this.mainNotice) {
            this.nonce = this.mainNotice.dataset.nonce;
            this.action = this.mainNotice.dataset.action;
            this.mainNotice.querySelector('.js-minimize').onclick = () => this.minimize();
            this.mainNotice.querySelector('.js-request-activation').onclick = () => this.requestActivation();
        }

        this.minimizedNotice = document.querySelector('.js-classic-editor-notice-minimized');
        if (this.minimizedNotice) {
            this.minimizedNotice.querySelector('.js-maximize').onclick = () => this.maximize();
        }

    }

    minimize() {
        this.tools.hide(this.mainNotice, true);
        this.tools.show(this.minimizedNotice, true);
        this.ajax({command: 'minimize'});
    }

    maximize() {
        this.tools.show(this.mainNotice, true);
        this.tools.hide(this.minimizedNotice, true);
        this.ajax({command: 'maximize'});
    }

    requestActivation() {
        this.ajax(
            {
                command: 'requestActivation',
                manager: this.mainNotice.querySelector('.js-translation-managers').value
            }
        )
            .then(message => this.activationResponse(message));
    }

    activationResponse(message) {
        alert(message);
    }

    /**
     * @param {object} data
     * @return {Promise<Response>}
     */
    ajax(data) {
        data.nonce = this.nonce;
        data.action = this.action;


        var queryString = Object.keys(data).map(key => key + '=' + data[key]).join('&');

        return fetch(
            this.ajaxUrl,
            {
                method: 'POST',
                body: queryString,
                headers: {
                    'Content-Type': 'application/x-www-form-urlencoded; charset=utf-8',
                },
                credentials: 'same-origin'
            }
        )
            .then(response => {
                if (!response.ok) {
                    throw new Error(response.statusText);
                }
                return response.json();
            })
            .then(json => json.data.message);
    }
}

export default TranslationEditorClassic;