/*globals WPML_TM_SETTINGS */

import AMSEndpoints from '../Models/AMSEndpoints';

class AMSAPI {
	/**
	 * @param {Request} request
	 */
	constructor (request) {
		this.request = request;
	}

	registerClient () {
		return this.request.post(AMSEndpoints.registerClient);
	}

	checkStatus () {
		return this.request.get(AMSEndpoints.checkStatus);
	}

	synchronize () {
		return this.request.get(AMSEndpoints.synchronizeTranslators).then(() => {
			return this.request.get(AMSEndpoints.synchronizeManagers);
		});
	}

	updateConsoleURL() {
		return this.request.get(AMSEndpoints.consoleURL).then((json) => {
			return json;
		});
	}
}

export default AMSAPI;
