import ATEEndpoints from '../Models/ATEEndpoints';

class ATEAPI {
	/**
	 * @param {Request} request
	 */
	constructor (request) {
		this.request = request;
	}

	/**
	 * @param {Object} obj
	 * @param {WPMLXLIFF} obj.xliff
	 * @param {string} obj.returnURL
	 *
	 * @return Promise
	 */
	createJob ({xliff, returnURL}) {
		const {sourceLang, targetLang, content} = xliff;

		return this.request.post(ATEEndpoints.createJob, {
			source_language: sourceLang,
			target_language: targetLang,
			file:            {
				name:    'some_page_en_fr.xliff',
				type:    'data:application/x-xliff;base64',
				content: content,
			},
			return_url:      returnURL,
		});
	}

	/**
	 * @param {string} ateJobId
	 *
	 * @return Promise
	 */
	getJobStatus (ateJobId) {
		return this.request.get(ATEEndpoints.getJobStatus(ateJobId));
	}

	/**
	 * @param {Object} args
	 * @param {String=} args.ateToken The token to fetch subsequent sync pages on ATE.
	 * @param {String=} args.lockKey The key to re-acquire the lock.
	 * @param {Number=} args.nextPage An integer for the next page to read.
	 * @param {Number=} args.numberOfPages An integer for the total number of page.
	 *
	 * @returns {Promise}
	 */
	async sync(args) {
		return this.request.post(ATEEndpoints.sync, args);
	}

	async retry(args) {
		return this.request.post(ATEEndpoints.retry, args);
	}

	/**
	 * @returns {Promise}
	 */
	async download(jobs, returnUrl) {
		return this.request.post(ATEEndpoints.download, {jobs, returnUrl});
	}
}

export default ATEAPI;
