/*jshint browser:true, devel:true */

import WPMLEndpoints from '../Models/WPMLEndpoints';
import WPMLXLIFF from '../WPMLXLIFF.js';

class WPMLAPI {
	/**
	 * @param {Request} request
	 */
	constructor (request) {
		this.request = request;
	}

	/**
	 * @param {numeric} jobId
	 *
	 * @return Promise
	 */
	fetchXLIFF (jobId) {
		return this.request.get(WPMLEndpoints.fetchXLIFF(jobId))
			.then(json => {
				// console.log('WPMLAPI.fetchXLIFF, fetch.then', json);

				return new WPMLXLIFF(json);
			});
	}

	/**
	 * @param {Object} obj
	 * @param {string} obj.jobId
	 * @param {Object} obj.ateJobData
	 *
	 * @return Promise
	 */
	storeATEJob ({jobId, ateJobData}) {
		return this.request.post(WPMLEndpoints.storeATEJob, {
			wpml_job_id:  jobId,
			ate_job_data: ateJobData,
		});
	}

	assignJob ({jobId, translatorId}) {
		return this.request.post(WPMLEndpoints.assignJob, {
			jobId,
			translatorId,
		});
	}
}

export default WPMLAPI;