
import * as R from "ramda";

export const JobsRetry = function (statusIconUpdater, ateAPI) {
    return async () => {

        let response = {};

        do {
            response = await ateAPI.retry(R.pick(['jobsToProcess'], response));
            if (response.processed.length) {
                statusIconUpdater.setStatusIconToSpin(response.processed.map( job => { return {jobId: job} } ))
            }
        } while (response.jobsToProcess.length);
    };
}
