import ReactDOM from "react-dom";
import {createStore, StoreProvider, thunk, useStoreActions, useStoreState} from "easy-peasy";
import React, {useEffect} from "react";
import Row from "antd/lib/row";
import Col from "antd/lib/col";
import "antd/lib/grid/style/index.css";
import "antd/lib/card/style/index.css";
import {identity, prop, propOr} from "ramda";
import Spin from "antd/lib/spin";
import "antd/lib/spin/style/index.css";
import {callEndpoint} from "wpml-common-js-source/src/Ajax";
import {setAction} from "../../../../../../../src/js/shared/store";
import {__} from "wpml-common-js-source/src/i18n";
import {dispatch} from "../../../../../../../src/js/shared/event";
import Button from "../../../../../../../src/js/shared/components/button";
import {default as StatusDisplay, Heading, Preparing} from "../translate-everything/components/Status"

export const enableAte = () => {
	const statusElement = document.querySelector('#wpml-auto-translate > .connect');
	if (statusElement) {
		statusElement.parentNode.style.display = 'block';

		ReactDOM.render(
			<StoreProvider store={store}>
				<Status/>
			</StoreProvider>,
			statusElement,
		);
	}
};

const Status = () => {
	const {success} = useStoreState(identity);
	const {enable} = useStoreActions(identity);

	useEffect(() => {
		enable()
	}, []);

	useEffect(() => {
		success && dispatch('ateEnabled')
	}, [success])

	return <>
		{!success && <StatusDisplay status={<StatusArea/>}/>}
	</>;
};

const StatusArea = () => {
	const {enable} = useStoreActions(identity);
	const {enabling, failedMessage} = useStoreState(identity);
	const header = enabling ?
		__('Connecting to WPML’s Advanced Translation Editor', 'wpml-translation-management' ) :
		prop('header', failedMessage);

	const connecting = <>
		<Col span={1} offset={1}>
			<Spin spinning={true}/>
		</Col>
	</>;

	const error = <>
		<Col offset={1}>
			<div className={'wpml-error'}>
				<p dangerouslySetInnerHTML={{__html: prop('description', failedMessage)}} />
				<Button type={'error'} onClick={enable}>
					{__('Try again', 'wpml-translation-management')}
				</Button>
			</div>
		</Col>
	</>;

	return <>
		<Heading heading={header}/>
		<Row>
			{enabling ? connecting : error}
		</Row>

	</>
};

const store = createStore({
	shouldTranslateEverything: true,
	notices: [],
	enabling: false,
	setEnabling: setAction('enabling'),
	enable: thunk(async (actions) => {
		actions.setEnabling(true);
		const {data: {success, data}} = await callEndpoint(prop('enableATE', ate_jobs_sync.endpoints), {});
		actions.setEnabling(false);
		actions.setSuccess(success);
		!success && actions.setFailedMessage(propOr([], 'error', data));
	}),

	success: false,
	setSuccess: setAction('success'),

	failedMessage: '',
	setFailedMessage: setAction('failedMessage'),

});
