/* global ate_jobs_sync */

import React from 'react';
import ReactDOM from 'react-dom';
import {StoreProvider, useStoreState} from 'easy-peasy';
import {hooks} from "../jobs-sync/app";


import StatusBar from './components/StatusBar';
import {partial, prop, objOf, pipe} from "ramda";
import NotificationBadge from "./components/NotificationBadge";
import {createSharedStore} from "./store";
import {callEndpoint} from "wpml-common-js-source/src/Ajax";

export const initializeStatusBar = () => {
    const element = document.getElementById('wpml-ate-status-bar-content');
    element.style.display = 'inline-flex';
    element.style.width = '400px';
    element.previousSibling.style.display = 'none';

    const store = createSharedStore(ate_jobs_sync, hooks);

	ReactDOM.render(
        <StoreProvider store={store}>
            <StatusBar/>
        </StoreProvider>,
        element
    );

    const countElement = document.getElementById('wpml-status-bar-count');

    ReactDOM.render(
        <StoreProvider store={store}>
            <NotificationBadge/>
        </StoreProvider>,
        countElement
    );
};
