import React, {useEffect} from 'react';
import {identity} from 'ramda';
import {useStoreState} from 'easy-peasy';
import {__} from 'wpml-common-js-source/src/i18n';
import {createInterpolateElement} from '@wordpress/element';
import Card from 'antd/lib/card';
import 'antd/lib/card/style/index.css';
import Row from 'antd/lib/row';
import Col from 'antd/lib/col';
import 'antd/lib/grid/style/index.css';
import './style/index.scss';

export default () => {
	const {totalJobs} = useStoreState(identity);

	useEffect(() => {
		if (!totalJobs) {
			document.dispatchEvent(new Event('WPMLManualTranslationStatusIsVisible'));
		}
	}, [totalJobs]);

	const paragraph = createInterpolateElement(
		__('Read more about how to translate your content in the <a>Getting Started Guide</a>', 'wpml-translation-management'),
		{
			a: <a href="https://wpml.org/documentation/getting-started-guide/" target="_blank"
			      className="wpml-external-link"/>,
		},
	);

	return !totalJobs && <Card className={'wpml-manual-translation-status'}>
		<Row>
			<Col span={16}>
				<h4>{__('Let\'s Start Translating!', 'wpml-translation-management')}</h4>
				<p>
					{__('Choose your content from the Translation Dashboard below and create your first translation job!', 'wpml-translation-management')}
				</p>
				<p>{paragraph}</p>
			</Col>
			<Col span={8}>
				<div id="wpml-manual-translation-status-notice"/>
			</Col>
		</Row>
	</Card>;
};
