/* global ate_jobs_sync */

import React from 'react';
import {prop} from 'ramda';
import ReactDOM from 'react-dom';
import {StoreProvider} from 'easy-peasy';
import Status from './components/Status';
import ManualTranslationStatus from './components/ManualTranslationStatus';
import {hooks} from '../jobs-sync/app';
import {createSharedStore} from '../status-bar/store';

export const initializeTranslationModeStatus = () => {
	const statusElement = document.querySelector('#wpml-auto-translate > .content');
	if (statusElement) {
		document.getElementById('wpml-auto-translate').style.display = 'block';

		const component = prop('isAutomaticTranslations', ate_jobs_sync) ? <Status/> : <ManualTranslationStatus/>;
		const store = createSharedStore(ate_jobs_sync, hooks);

		ReactDOM.render(
			<StoreProvider store={store}>
				{component}
			</StoreProvider>,
			statusElement,
		);
	}
};
