import moment from 'moment'
import JobsEndpoints from "./JobsEndpoints";
import queryBuilder from "../../shared/QueryBuilder";
import {DATE_FORMAT} from "../../translationDashboard/pickup-translations/components/PollingBox";

export default class JobsAPI {

	/**
	 * @param {Request} request
	 */
	constructor(request) {
		this.request = request;
	}

	synchronizeStatusesWithTP(setLastPickUpDate = false) {
		const formData = new FormData();
		formData.append('action', JobsEndpoints.syncJobsAction);

		if (setLastPickUpDate) {
			formData.append('update_last_picked_up', 1);
		}

		return fetch(ajaxurl, {
			method: "POST",
			body: formData
		}).then((response) => {
			if (!response.ok) {
				throw new Error("Status synchronization has failed.");
			}

			return response.json();
		}).then(json => {
			return json.data;
		});
	}

	loadJobs(params = {}) {
		const url = queryBuilder(JobsEndpoints.getJobs, params);

		return this.request.get(url);
	}

	applyTranslation(jobs) {
		const params = jobs.map(({id, type}) => ({
			id,
			type
		}));

		return this.request.post(JobsEndpoints.applyTranslations, params);
	}

	cancelJobs(jobs) {
		const params = jobs.map(({id, type}) => ({
			id,
			type
		}));

		return this.request.post(JobsEndpoints.cancelJobs, params);
	}

	async syncBatch(tpBatchIds) {
		const params = {batchId: tpBatchIds};

		return this.request.post(JobsEndpoints.syncBatchAction, params);
	}

	async checkBatchSync() {
		return this.request.get(JobsEndpoints.checkSyncBatchAction);
	}

	applyTranslationToElement(element_id, element_type) {
		return this.request.post(JobsEndpoints.applyTranslations, {
			original_element_id: element_id,
			element_type
		});
	}

	assignTranslator(job, translatorId) {
		const params = {
			jobId: job.type === "string" ? job.id : job.extra_data.icl_translate_job_id,
			type: job.type,
			translatorId
		};

		return this.request.post(JobsEndpoints.assignTranslator, params);
	}

	async downloadXLIFF(job) {
		return this.request.download(JobsEndpoints.downloadTranslation(job));
	}
};