import React from 'react';

import {JobsConsumer} from "../context/JobsProvider";
import {StringsConsumer} from "../context/StringsContext";
import {SettingsConsumer} from "../../jobs/context/SettingsProvider";
import connect from "../context/connect";

export class AssignTranslator extends React.Component {
	constructor(props) {
		super(props);

		this.state = {
			selectedTranslator: '-',
			localTranslators: props.localTranslators.filter(
				( { value, label, languagePairs } ) => (
					this.hasLanguagePair(props.job.language_codes, languagePairs)
				)
			)
		};
	}

	hasLanguagePair( jobLanguageCodes, languagePairs ) {
		return languagePairs.some( pair => {
			return JSON.stringify( pair ) === JSON.stringify( jobLanguageCodes );
		} );
	}

	handleChange(event) {
		this.setState({selectedTranslator: event.target.value});
	}

	assignAction() {
		if (this.state.selectedTranslator !== "-") {
			this.props.assignTranslator(
				this.props.job,
				this.state.selectedTranslator
			)
		}
	}

	render() {
		return (
			<span>
				<select
					value={this.state.selectedTranslator}
					onChange={e => this.handleChange(e)}
				>
					<option value="-">
						{this.props.strings.selectTranslator}
					</option>
					{
						this.state.localTranslators.map( ( { value, label } ) => (
							<option value={value} key={value}>{label}</option>
						) )
					}
				</select>
				<button className="button button-secondary" onClick={e => this.assignAction()}>
					{this.props.strings.assignTranslator}
				</button>
			</span>
		);
	}
}

export default connect(AssignTranslator, StringsConsumer, JobsConsumer, SettingsConsumer);