import React from 'react';

import {JobsConsumer} from "../context/JobsProvider";
import {SelectionConsumer} from "../context/SelectionProvider";
import {StringsConsumer} from "../context/StringsContext";
import connect from "../context/connect";

export const actions = {
	NONE: 'none',
	APPLY_TRANSLATIONS: 'apply-tranlations',
	CANCEL_JOBS: 'cancel-jobs',
};

class BulkActions extends React.Component {

	constructor(props) {
		super(props);

		this.state = {
			selectedAction: actions.NONE
		};
	}

	applyAction() {
		if (this.props.getSelectedJobs().length) {
			switch (this.state.selectedAction) {
				case actions.APPLY_TRANSLATIONS:
					this.props.applyTranslations(
						this.props.getSelectedJobs()
					);
					break;
				case actions.CANCEL_JOBS:
					this.props.cancelJobs(
						this.props.getSelectedJobs()
					);
					break;
			}
		}
	}

	handleChange(event) {
		this.setState({selectedAction: event.target.value});
	}

	render() {
		const strings = this.props.strings;

		return (
			<div className="alignleft actions jobs_select_actions">
				<select  value={this.state.selectedAction} onChange={e => this.handleChange(e)}>
					<option value={actions.NONE}>
						{strings.bulkActions}
					</option>
					<option value={actions.APPLY_TRANSLATIONS}>
						{strings.getTranslations}
					</option>
					<option value={actions.CANCEL_JOBS}>
						{strings.cancelJobs}
					</option>
				</select>

				<button className="button button-secondary" onClick={e => this.applyAction()}>
					{strings.apply}
				</button>
			</div>
		);
	}
}

export default BulkActions;

export const ConnectedBulkActions = connect(BulkActions, StringsConsumer, JobsConsumer, SelectionConsumer);