import React from 'react';

import List from './List';
import Loader from './Loader';

import {JobsConsumer} from '../context/JobsProvider';
import connect from "../context/connect";
import {ConnectedSelectionProvider as SelectionProvider} from "../context/SelectionProvider";
import {ConnectedPaginationProvider as PaginationProvider} from "../context/PaginationProvider";
import Error from './Error';
import Confirmation from './Confirmation';

import {ConnectedPagination as Pagination} from './Pagination';
import Filters from "./Filters";
import {ConnectedBulkActions} from "./BulkActions";

const JobsTab = ({error = false, progress = false, confirmation = false, jobs = []}) => {
	return (
		<SelectionProvider>
			<PaginationProvider>
				<Filters/>

				{error && <Error value={error}/>}
				{confirmation && <Confirmation value={confirmation}/>}
				{progress && <Loader/>}
				<List jobs={jobs}/>
				<div className="tablenav clearfix bottom">
					<ConnectedBulkActions/>
					<Pagination/>
				</div>

			</PaginationProvider>
		</SelectionProvider>
	);
};

export default JobsTab;

export const ConnectedJobsTab = connect(JobsTab, JobsConsumer);