import React from 'react';

import {SettingsConsumer} from "../context/SettingsProvider";
import {SelectionConsumer} from "../context/SelectionProvider";
import {JobsConsumer} from "../context/JobsProvider";
import {StringsConsumer} from "../context/StringsContext";
import connect from "../context/connect";

import initTooltip from "../util/tooltip";


export default class ListHeader extends React.Component {

	constructor(props) {
		super(props);

		this.tooltip = React.createRef();

	}

	componentDidMount() {
		this.refreshTooltip();
	}

	componentDidUpdate() {
		this.refreshTooltip();
	}

	refreshTooltip() {
		initTooltip(this.tooltip.current);
	}

	render() {
		const {columns, allSelected = false, selectAll, hasExternalActions, strings} = this.props;

		return (
			<tr>
				<td className="check-column">
					<label className="screen-reader-text" htmlFor="wpml-job-list-select-all">{strings.selectAll}</label>
					<input
						id="wpml-job-list-select-all"
						type="checkbox"
						onClick={() => selectAll(!allSelected)}
						checked={allSelected}
					/>
				</td>
				{
					Object.values(columns).map((column) => (
						<th key={column}>
							{column}
						</th>
					))
				}
				<th className="column-actions">
					{strings.actions}
				</th>
				{
					hasExternalActions() &&
					<th className="column-external-actions">
						{strings.externalActions}
						<i
							className="otgs-ico-help js-otgs-popover-tooltip"
							title={strings.externalActionsTooltip}
							ref={this.tooltip}
						/>
					</th>
				}
			</tr>
		);
	}
}

export const ConnectedListHeader = connect(ListHeader, SettingsConsumer, SelectionConsumer, JobsConsumer, StringsConsumer);