import React from "react";

const Action = props => {
	const {isActive, onClick, icon, strings, ...rest} = props;

	const cssClasses = `icon ${icon} js-otgs-popover-tooltip` + (!isActive ? " disabled" : "");

	return <a
		onClick={() => isActive && onClick()}
		className={cssClasses}
		data-tippy-delay="[200, 0]"
		title={isActive ? strings.activeTitle : strings.disabledTitle}
		{...rest}
	>
	</a>
};

export default Action;