import Action from "./Action";
import {canBeBatchSynced, isLocal, JOB_STATUSES} from "../../../model/jobs";
import React from "react";

import connect from "../../../context/connect";
import {JobsConsumer} from "../../../context/JobsProvider";
import {StringsConsumer} from "../../../context/StringsContext";

export const BatchSync = ({syncBatch, strings, job}) => {

		const getDisabledTitle = (job, statusValues) => {
			if (isLocal(job)) {
				return statusValues.local;
			} else if (job.isBatchSynced) {
				return statusValues.alreadySynced;
			}

			switch (job.status) {
				case JOB_STATUSES.COMPLETED:
					return statusValues.completed;
				case JOB_STATUSES.CANCELLED:
					return statusValues.cancelled;
				case JOB_STATUSES.TRANSLATION_READY_TO_DOWNLOAD:
					return statusValues.readyToDownload;
				default:
					return "";
			}
		};

		return (<Action
			isActive={canBeBatchSynced(job)}
			icon="otgs-ico-status"
			onClick={() => syncBatch(job)}
			strings={{
				activeTitle: strings.jobActions.checkStatus.active,
				disabledTitle: getDisabledTitle(job, strings.jobActions.checkStatus),
			}}
		/>);
	}
;

export default connect(BatchSync, JobsConsumer, StringsConsumer);






