import {canBeCanceled, isLocal, JOB_STATUSES} from '../../../model/jobs';
import Action from './Action';
import React from 'react';

import connect from '../../../context/connect';
import {JobsConsumer} from '../../../context/JobsProvider';
import {StringsConsumer} from '../../../context/StringsContext';

const disabledTooltip = (job, cancelStrings) => {
	if (job.status === JOB_STATUSES.CANCELLED) {
		return cancelStrings.alreadyCanceled;
	} else if (job.status === JOB_STATUSES.COMPLETED) {
		return cancelStrings.alreadyFinished;
	} else if (!isLocal(job)) {
		return cancelStrings.notLocalJob;
	}

	return '';
};

export const Cancel = ({
						   cancelJobs,
						   strings: {jobActions: {cancel: cancelStrings}},
						   job,
					   }) => (
	<Action
		isActive={canBeCanceled(job)}
		icon="otgs-ico-cancel"
		onClick={() => cancelJobs([job])}
		strings={{
			activeTitle:   cancelStrings.activeIconText,
			disabledTitle: disabledTooltip(job, cancelStrings),
		}}
	/>
);

export default connect(Cancel, StringsConsumer, JobsConsumer);
