import {canDownloadXLIFF, isLocal, JOB_STATUSES} from "../../../model/jobs";
import JobsEndpoints from "../../../api/JobsEndpoints";
import Action from "./Action";
import React from "react";

import connect from "../../../context/connect";
import {StringsConsumer} from "../../../context/StringsContext";
import {JobsConsumer} from "../../../context/JobsProvider";
import {create} from "../../../model/DownloadXLIFF";

const getDisabledTooltip = (strings, job) => {
	if (isLocal(job)) {
		return strings.localJob;
	} else if (job.status === JOB_STATUSES.CANCELLED) {
		return strings.canceled.replace("TS_NAME", job.translation_service);
	} else {
		return strings.notReady;
	}
};

export const DownloadXLIFF = ({
	                              strings: {jobActions: {downloadXLIFF: strings}},
	                              job,
	                              downloadXLIFF
                              }) => {
	const isActive = canDownloadXLIFF(job);

	return <Action
		key="download-xliff"
		isActive={isActive}
		icon="otgs-ico-download"
		onClick={() => downloadXLIFF(job)}
		strings={{
			activeTitle: strings.activeIconText,
			disabledTitle: getDisabledTooltip(strings, job)
		}}
	/>
};

export default connect(DownloadXLIFF, StringsConsumer, JobsConsumer);