import React from "react";

const Title = ({name, url}) => {
	const limit = 80;
	const title = name.length < limit ? name : name.substr(0, limit) + "...";

	return (
		<td>
			{
				url ? <a href={url} target="_self">{title}</a> : title
			}
		</td>
	);
};

export default Title;