import AssignTranslator from "../../AssignTranslator";
import React from "react";
import {JOB_STATUSES} from "../../../model/jobs";
import {SettingsConsumer} from "../../../context/SettingsProvider";
import {StringsConsumer} from "../../../context/StringsContext";
import connect from "../../../context/connect";
import {sprintf} from 'sprintf-js';

export const Translator = props => {
	let value = "";
	const {job, batchUrl} = props;

	if (job.translation_service_id === 'local') {
		if (job.translator_name) {
			value = job.translator_name;
		} else if (job.status === JOB_STATUSES.WAITING_FOR_TRANSLATOR) {
			value = <AssignTranslator job={job}/>;
		}
	} else {
		value = (
			<a target="_blank"
			   rel="noopener"
			   href={sprintf(batchUrl, job.batch.tp_id)}
			   className="wpml-tm-batch-url wpml-external-link"
			>
				{job.translation_service}
			</a>
		);
	}

	if (job.tp_id) {
		return <td>{value} [{sprintf(props.strings.tpJobId, job.tp_id)}]</td>;
	} else {
		return <td>{value}</td>;
	}
};

export default connect(Translator, SettingsConsumer, StringsConsumer);