import React from 'react';

import WrappedPagination from '../../shared/Pagination/Pagination';
import {PaginationConsumer} from "../context/PaginationProvider";

import {JobsConsumer} from "../context/JobsProvider";
import {SettingsConsumer} from "../context/SettingsProvider";
import {StringsConsumer} from "../context/StringsContext";
import connect from "../context/connect";

export class Pagination extends React.Component {

	render() {
		return (
			<PaginationConsumer>
				{data => {
					const setPage = (page) => {
						if (data.setPage(page)) {
							this.props.loadJobs(page);
						}
					};

					return (
						<WrappedPagination
							firstPage={() => setPage(1)}
							previousPage={() => setPage(data.currentPage - 1)}
							nextPage={() => setPage(data.currentPage + 1)}
							lastPage={() => setPage(data.getTotalPages())}
							setPage={setPage}
							position={'bottom'}
							pagination={{
								currentPage: data.currentPage,
								totalPages: data.getTotalPages(),
								itemsPerPage: this.props.pageSize,
								totalItems: this.props.totalJobsCount
							}}
							strings={this.props.strings}
						/>
					);
				}}
			</PaginationConsumer>
		);
	}
}


export const ConnectedPagination = connect(Pagination, JobsConsumer, SettingsConsumer, StringsConsumer);