import React, {Component} from 'react';

import {SettingsConsumer} from "./SettingsProvider";
import {JobsConsumer} from "./JobsProvider";
import connect from "./connect";

const PaginationContext = React.createContext({});

export default class PaginationProvider extends Component {
	constructor(props) {
		super(props);

		this.state = {
			currentPage: 1
		};
	}

	setPage(page) {
		if (page >= 1 && page <= this.getTotalPages()) {
			this.setState({
				currentPage: page
			});

			return true;
		}

		return false;
	}

	getTotalPages() {
		return Math.ceil(this.props.totalJobsCount / this.props.pageSize);
	}

	render() {
		const {children} = this.props;

		return (
			<PaginationContext.Provider
				value={{
					currentPage: this.state.currentPage,
					setPage: this.setPage.bind(this),
					getTotalPages: this.getTotalPages.bind(this)
				}}
			>
				{children}
			</PaginationContext.Provider>
		);
	}
}

export const PaginationConsumer = PaginationContext.Consumer;

export const ConnectedPaginationProvider = connect(PaginationProvider, JobsConsumer, SettingsConsumer);
