/*globals WPML_TM_SETTINGS */

import React, {Component} from 'react';

const SettingsContext = React.createContext({});

export class SettingsProvider extends Component {

	constructor(props) {
		super(props);

		this.state = {
			columns: WPML_TM_SETTINGS.settings.columns,
			sortable: WPML_TM_SETTINGS.settings.sortable,
			pageSize: WPML_TM_SETTINGS.settings.pageSize,
			jobsStatuses: WPML_TM_SETTINGS.jobStatuses,
			languages: WPML_TM_SETTINGS.languages,
			translatedByFilters: WPML_TM_SETTINGS.translatedByFilters,
			localTranslators: WPML_TM_SETTINGS.localTranslators,
			siteKey: WPML_TM_SETTINGS.siteKey,
			checkBatchNonce: WPML_TM_SETTINGS.checkBatchNonce,
			translationService: WPML_TM_SETTINGS.translationService,
			batchUrl: WPML_TM_SETTINGS.batchUrl,
		};
	}


	render() {
		const {children} = this.props;

		return (
			<SettingsContext.Provider
				value={{
					...this.state
				}}
			>
				{children}
			</SettingsContext.Provider>
		);
	}
}

export const SettingsConsumer = SettingsContext.Consumer;