import React from "react";

export default (Component, ...Consumers) => {
	return Consumers.reduce((PreviousComponent, CurrentConsumer) => {
		return (props) => {
			return (
				<CurrentConsumer>
					{data => <PreviousComponent {...props} {...data} />}
				</CurrentConsumer>
			);
		}
	}, props => <Component {...props} />);
};