export class BatchSync {
	/**
	 *
	 * @param {JobsAPI} jobAPI
	 * @param {Object} hooks
	 * @param {number} checkInterval
	 */
	constructor(jobAPI, hooks, checkInterval = 30000) {
		this.jobAPI = jobAPI;
		this.hooks = hooks;
		this.interval = checkInterval;

		this.MAX_ATTEMPTS = 5;
	}

	/**
	 *
	 * @param {number[]} tpBatchIds
	 * @returns {*}
	 */
	async run(tpBatchIds) {
		this.hooks.doAction('wpml-js-run-batch-sync-action', tpBatchIds);

		const queuedBatches = await this.jobAPI.syncBatch(tpBatchIds);

		return this.checkProgress();
	}

	async checkProgress() {
		this.attempts = 0;

		while (!await this.runCheck()) ;

		return true;
	}

	async runCheck() {
		return new Promise(resolve => {
			setTimeout(async () => {
				const queuedBatches = await this.jobAPI.checkBatchSync();
				this.hooks.doAction('wpml-js-status-batch-sync-action', queuedBatches);

				resolve(queuedBatches.length === 0 || ++this.attempts === this.MAX_ATTEMPTS);
			}, this.interval);
		});
	}
}