import ATEAPI from '../../ate/API/ATEAPI';
import Request, {hooks} from '../../shared/Request';
import {JobsSync} from '../../ate/JobsSync';
import {JOB_STATUSES} from "./jobs";
import {createHooks} from '@wordpress/hooks';

export class SyncATEJobs {
	/**
	 * @param {JobsSync} jobsSync
	 */
	constructor(jobsSync) {
		this.jobsSync = jobsSync;
	}

	/**
	 *
	 * @param jobsOnCurrentPage
	 * @returns {Promise<*>}
	 */
	async sync(jobsOnCurrentPage) {
		try {
			const syncedJobs = await this.jobsSync.run();
			if (syncedJobs.length === 0) {
				return jobsOnCurrentPage;
			}

			return jobsOnCurrentPage.map(jobOnCurrentPage => {
				if (jobOnCurrentPage.type === 'string') {
					return jobOnCurrentPage;
				}

				const isSynced = syncedJobs.find(syncedJobId => parseInt(syncedJobId) === jobOnCurrentPage.extra_data.icl_translate_job_id) !== undefined;
				if (!isSynced) {
					return jobOnCurrentPage;
				}

				jobOnCurrentPage.status = JOB_STATUSES.COMPLETED;

				return jobOnCurrentPage;
			});
		} catch (e) {
			return jobsOnCurrentPage;
		}
	}
}

/**
 * @returns {SyncATEJobs}
 */
export const create = () => {
	const hooks = createHooks();
	const ateAPI = new ATEAPI(new Request());
	const jobsSync = new JobsSync(ateAPI, hooks);

	return new SyncATEJobs(jobsSync);
};