import {__ as R__, anyPass, includes, pipe, prop, propEq} from "ramda";

export const JOB_STATUSES = {
	CANCELLED: 0,
	WAITING_FOR_TRANSLATOR: 1,
	IN_PROGRESS: 2,
	NEEDS_UPDATE: 3,
	TRANSLATION_READY_TO_DOWNLOAD: 4,
	COMPLETED: 10,
	ATE_NEEDS_RETRY: 40
};

export const ATE_JOBS_STATUSES = {
	TRANSLATED: 6,
	DELIVERING: 7,
	EDITED: 15,
	CANCELLED: 20,
	NO_CREDIT: 31,
	HIDDEN: 42,
};

export const doesNeedReview = anyPass([propEq('review_status', 'NEEDS_REVIEW'), propEq('review_status', 'EDITING')]);

export const canBeCanceled = job => {
	if (!isLocal(job)) {
		return false;
	}

	return job.status === JOB_STATUSES.WAITING_FOR_TRANSLATOR || job.status === JOB_STATUSES.IN_PROGRESS;
};

export const isLocal = job => job.translation_service_id === 'local';

export const canBeBatchSynced = job => {
	return !isLocal(job)
		&& (job.status === JOB_STATUSES.IN_PROGRESS || job.status === JOB_STATUSES.COMPLETED)
		&& job.batch.tp_id
		&& !job.isBatchSynced;
};

export const canBeTranslationDownloaded = job => !isLocal(job) && (job.status === JOB_STATUSES.TRANSLATION_READY_TO_DOWNLOAD || job.status === JOB_STATUSES.COMPLETED);

export const isInProgress = pipe(prop('status'), includes(R__, [JOB_STATUSES.WAITING_FOR_TRANSLATOR, JOB_STATUSES.IN_PROGRESS]));

export const canDownloadXLIFF = job => canBeTranslationDownloaded( job );

export const isJobEqual = (job1, job2) => job1.id === job2.id && job1.type === job2.type;

export const hasJobsWithStatus = (jobs, status) => {
	return jobs.find(job => job.status === status) !== undefined;
};
