/* globals ajaxurl */

class TMEditorSaveSetting {
	constructor(ajax, postId) {
		this.ajax = ajax;
		this.postId = postId;
	}

	save(mode, useTMEditor, nonce, onSaved) {
		this.ajax( {
			type: 'POST',
			url: ajaxurl,
			dataType: 'json',
			data: {
				action: 'wpml-tm-editor-mode',
				mode: mode,
				useTMEditor: useTMEditor,
				postId: this.postId,
				nonce: nonce
			},
			success: function ( response ) {
				if ( response.success ) {
					onSaved();
				}
			}
		} );
	}

}

export default TMEditorSaveSetting;