import jQueryDialog from '../shared/jQueryDialog';

class TMEditorSelectDialog extends jQueryDialog {

	constructor($, content, saveSetting, setLinks) {
		super($, 'js-tm-editor-dialog', content);

		this.toggle = content.find('.js-toggle-tm-editor');
		this.toggle.on('change', () => this.open());

		this.dialogElement.on('dialogclose', () => this.onClose());

		this.saveSetting = saveSetting;
		this.setLinks = setLinks;
	}

	open() {
		if (this.toggle.prop('checked')) {
			this.setTitle(this.dialogElement.data('tm-editor'));
		} else {
			this.setTitle(this.dialogElement.data('wp-editor'));
		}
		super.open();
		this.applyingChanges = false;
	}

	onClose() {
		if (!this.applyingChanges) {
			// Dialog is being closed by cancel buttons or escape.
			// We need to set the checkbox back to its original state
			this.toggle.off('change');
			this.toggle.prop('checked', !this.toggle.prop('checked'));
			this.toggle.on('change', () => this.open());
		}
	}

	getButtons() {
		return [
			this.getDefaultCancelButton(),
			{
				class: 'button-primary alignright ' + this.dialogId + '-ok',
				text: this.dialogElement.data('apply-text'),
				click: () => this.okApply()
			}
		];
	}

	okApply() {
		this.applyingChanges = true;
		this.setSaveButtonDisabled( true );
		this.saveSetting.save(
			this.find('input[name="tm-editor-mode"]:checked').val(),
			this.toggle.prop('checked'),
			this.dialogElement.data('nonce'),
			() => this.onSaved()
		);
	}

	onSaved() {
		this.setLinks.setMode(this.toggle.prop('checked'));
		this.close();
		this.setSaveButtonDisabled(false);
		this.applyingChanges = false;
	}

	setSaveButtonDisabled( is_disabled ) {
		this.dialogElement.parent('.ui-dialog').find('.button-primary').prop('disabled', is_disabled);
	}
}

export default TMEditorSelectDialog;