/* globals jQuery */

import TMEditorSelectDialog from './TMEditorSelectDialog';
import TMEditorSaveSetting from './TMEditorSaveSetting';
import TMEditorSetLinks from './TMEditorSetLinks';

function initTMEditorSelectDialog() {
	if ( ! document.getElementById( 'post_ID' ) ) {
		// bail out early if #post_ID absent.
		return;
	}
	new TMEditorSelectDialog(
		jQuery,
		jQuery('#icl_div'),
		new TMEditorSaveSetting(jQuery.ajax, document.getElementById( 'post_ID' ).value),
		new TMEditorSetLinks(jQuery('#icl_div'))
	);
}

document.addEventListener('DOMContentLoaded', () => initTMEditorSelectDialog());
document.addEventListener('WPMLLanguagesMetaBoxesRefreshed', () => initTMEditorSelectDialog());