import Tools from './Shared/Tools';

class MCSCustomFieldSettingsFilter {
	constructor(filterContainer, {minSearchLength, searchTimeOutValue}) {
		this.minSearchLength = minSearchLength;
		this.searchTimeOutValue = searchTimeOutValue;

		this.timeout = null;
		this.onUpdateRequired = null;

		this.tools = new Tools();

		this.filterContainer = filterContainer;

		this.initData();
	}

	initData() {
		this.searchField = this.filterContainer.querySelector('.wpml_tm_search');
		this.prevSearch = this.searchField.value;
		this.spinner = this.filterContainer.querySelector('.spinner');
	}

	bindEvents() {
		// We need onkeyup event to process BackSpace and Delete properly
		this.searchField.onkeyup = () => this.updateSearch();
	}

	getSearchText() {
		return this.searchField.value.trim();
	};

	updateSearch(event) {
		if (this.timeout){
			clearTimeout(this.timeout);
		}
		this.timeout = setTimeout(() => { this.maybeDoSearch() }, this.searchTimeOutValue);
	};

	maybeDoSearch() {
		const newSearch = this.getSearchText();
		if (this.mustUpdate(newSearch)) {
			this.prevSearch = newSearch;
			this.updateFilter();
		}
	}

	mustUpdate(newSearch) {
		return (newSearch.length === 0 || newSearch.length >= this.minSearchLength) &&
			this.prevSearch !== newSearch;
	}

	updateFilter() {
		this.tools.showSpinner(this.spinner);
		this.onUpdateRequired();
	}

	onUpdated() {
		this.tools.hideSpinner(this.spinner);
		this.initData();
		this.bindEvents();
	}
}

export default MCSCustomFieldSettingsFilter;
