import WPMLTMSettings from '../../shared/WPMLTMSettings';
import {subscribe, dispatch} from "../../../../../../../src/js/shared/event";
import {equals} from "ramda";
import initTooltip from "../../jobs/util/tooltip";
import {__} from 'wpml-common-js-source/src/i18n';

class TranslationMethod extends WPMLTMSettings {

	constructor() {
		super();

		this.translationMethodOptions = [];
		this.oldJobsMethodOptions = [];

		this.form = document.getElementById('icl_doc_translation_method');
		if (this.form) {
			this.translationMethodOptions = this.form.querySelectorAll('[type="radio"][name="t_method"]');
			this.oldJobsMethodOptions = this.form.querySelectorAll('[type="radio"][name="wpml-old-jobs-editor"]');
			this.submitButton = this.form.querySelector('.button-primary');

			this.initEventHandlers();
		}
	}

	initEventHandlers() {

		for (let i = 0; i < this.translationMethodOptions.length; ++i) {
			const option = this.translationMethodOptions[i];

			if (option.checked) {
				this.updateOldJobsMethods(option.value);
			}

			option.onclick = (e) => {
				const currentTarget = e.currentTarget;
				this.updateOldJobsMethods(currentTarget.value);

				this.saveForm();
				dispatch('editor-mode', currentTarget.value);
			};
		}

		subscribe('auto-translation-method')
			.then(equals('automatic'))
			.then(this.disableClassicEditor.bind(this));
	}

	disableClassicEditor(disable) {
		this.translationMethodOptions.forEach(option => {
			if (option.value === '1') {
				option.disabled = disable;

				const tooltip = disable
					? __('You must use the Advanced Translation Editor if you want to translate your content automatically.', 'wpml-translation-management')
					: '';

				const label = option.parentNode;
				label.setAttribute('title', tooltip);
				if (!label._tippy) {
					initTooltip(label, 'otgs');
				}

			}
		})
	}

	updateOldJobsMethods(method) {
		for (let i = 0; i < this.oldJobsMethodOptions.length; ++i) {
			const option = this.oldJobsMethodOptions[i];
			option.disabled = 'ATE' !== method;
			if (option.disabled) {
				option.checked = option.value.toUpperCase() !== 'ATE';
			}
		}
	}

	saveForm() {
		if (this.submitButton) {
			this.submitButton.click();
		}
	}
}

export default TranslationMethod;
