import React, {useState} from 'react';
import ReactDOM from 'react-dom';
import {__, sprintf} from 'wpml-common-js-source/src/i18n';

/**
 * @param {ATEControls} ateControls
 */
export const initializeAteTroubleshooting = ateControls => {
	const synchronizeButtonElement = document.getElementById('synchronize-ate-ams');
	if (synchronizeButtonElement) {
		ReactDOM.render(<SynchronizeButton ateControls={ateControls}/>, synchronizeButtonElement);
	}
};

const SynchronizeButton = ({ateControls}) => {
	const [error, setError] = useState('');
	const [inProgress, setInProgress] = useState(false);

	const onClick = () => {
		setInProgress(true);
		ateControls.handleSynchronize().catch(reason => setError(reason)).finally(() => setInProgress(false));
	};
	return (
		<div>
			<button disabled={inProgress} className="button-secondary" onClick={() => onClick()}>
				{__('Synchronize translators and translation managers with ATE', 'wpml-translation-management')}
				{inProgress && <span className="spinner" style={{visibility: 'visible'}}/>}
			</button>
			{error && <SynchronizeError message={error}/>}
		</div>
	);
};

const SynchronizeError = ({message}) => {
	const hint = sprintf(
		__('Please try again in a few minutes. If the problem persists, please contact %sWPML support%s.', 'wpml-translation-management'),
		'<a target="_blank" rel="noopener" href="https://wpml.org/forums/forum/english-support/">',
		'</a>',
	);
	return (
		<div className="otgs-notice otgs-notice__errors error inline">
			<p className="message">{message}</p>
			<p className="help" dangerouslySetInnerHTML={{__html: sanitizeHtml(hint, {allowedTags: ['a']})}}/>
		</div>
	);
};