import TranslationMethodATE from './UI/TranslationMethodATE';
import AMSAPI from '../ate/API/AMSAPI';
import Request from '../shared/Request';
import ATEControls from './UI/ATEControls';
import TranslationMethod from './UI/TranslationMethod';
import OldJobsEditor from './UI/OldJobsEditor';
import MCSCustomFieldSettings from "./UI/MCSCustomFieldSettings";
import Tools from "./UI/Shared/Tools";
import {initializeAteTroubleshooting} from "./UI/Troubleshooting";

document.addEventListener('DOMContentLoaded', () => {
	const request = new Request();

	new TranslationMethod();
	new OldJobsEditor();

	const amsAPI = new AMSAPI(request);
	const ateControls = new ATEControls(amsAPI);

	if (ateControls.isStatusOnly()) {
		ateControls.initEventHandlers();
	} else {
		const translationMethodATE = new TranslationMethodATE(ateControls);
		translationMethodATE.init();
	}

	initializeAteTroubleshooting(ateControls);

	const tools = new Tools();

	const customFieldsTables = document.querySelectorAll('.wpml-custom-fields-settings');
	Array.from(customFieldsTables).map(customFieldsTable => {
		const table = new MCSCustomFieldSettings(customFieldsTable, tools);
		table.bindEvents();
	});

});

