import React from 'react';

import PaginationNavArrow from './PaginationNavArrow';
import PaginationControls from './PaginationControls';

export default class Pagination extends React.Component {
	render() {
		const {
			firstPage,
			previousPage,
			nextPage,
			lastPage,
			setPage,
			pagination,
			strings
		} = this.props;

		const {
			currentPage,
			totalPages,
			itemsPerPage,
			totalItems
		} = pagination;

		if (totalItems === 0) {
			return '';
		}

		const paginationBlock = (
			<span className="pagination-links">
				<PaginationNavArrow className="first-page" label={strings.firstPage} onClick={firstPage}
									isActive={currentPage > 1}/>
				<PaginationNavArrow className="previous-page" label={strings.previousPage} onClick={previousPage}
									isActive={currentPage > 1}/>

				<PaginationControls onChange={setPage} pagination={pagination} strings={strings}/>

				<PaginationNavArrow className="next-page" label={strings.nextPage} onClick={nextPage}
									isActive={currentPage < totalPages}/>
				<PaginationNavArrow className="last-page" label={strings.lastPage} onClick={lastPage}
									isActive={currentPage < totalPages}/>
			</span>
		);

		return (

			<div className="tablenav-pages">
				<span className="displaying-num">{strings.totalItemsText.replace(/\d+/, totalItems)}</span>
				{
					(totalItems > itemsPerPage) && paginationBlock
				}
			</div>
		);
	}
}
