import 'url-polyfill';

function addParams(params, urlSearchParams) {
	Object.entries(params).map(([key, value]) => {
		if (Array.isArray(value)) {
			value.map(nestedValue => urlSearchParams.append(`${key}[]`, nestedValue));
		} else if (typeof  value === "object") {
			return Object.entries(value).map(([nestedKey, nestedValue]) => {
				return urlSearchParams.set(`${key}[${nestedKey}]`, nestedValue);
			});
		} else {
			return urlSearchParams.set(key, value);
		}
	});

	return urlSearchParams;
}

export default (href, params) => {
	const tmp_host = 'http://testsite.local';

	const url = new URL(href, tmp_host);
	addParams(params, url.searchParams);

	return url.href.replace(tmp_host, "");
};