import React, {useState} from 'react';
import Row from "antd/lib/row";
import Col from "antd/lib/col";
import "antd/lib/grid/style/index.css";
import {__ as _, always, append, cond, equals, gt, keys, splitEvery, take, T as otherwise} from "ramda";
import Spin from "antd/lib/spin";
import 'antd/lib/spin/style/index.css';

export default ({postTypes}) => {

	const [showAll, setShowAll] = useState(false);

	const padToFour = lst => {
		return lst.length < 4 ? padToFour(append(null, lst)) : lst;
	};

	const types = keys(postTypes);
	const span = cond([
		[gt(_, 3), always(6)],
		[equals(3), always(8)],
		[otherwise, always(12)]
	])(types.length);
	const rows = splitEvery(4, types);
	const rowsToShow = showAll ? rows.map(padToFour) : take(1, rows);

	return <div className={'post-types'}>
		{rowsToShow.map((row, index) => <Row key={index} className={'post-types-row'} gutter={[0, 0]}>
			{row.map(type => <Col key={type} className={'post-type-col'} span={span}>
				<PostType type={type} count={type ? postTypes[type] : null}/>
			</Col>)}
		</Row>)}
		{!showAll && rows.length > 1 &&
		<Row>
			<Col span={24}>
				<a className={'see-all'} onClick={() => setShowAll(true)}>See all <Arrow/></a>
			</Col>
		</Row>}
	</div>
}

const PostType = ({type, count}) => (
	<div className={'post-type'}>
		{type && <div className={'post-type__details'}>
			<h3>{count>=0 ? count : <Spin spinning={true}/> }</h3>
			{type}
		</div>}

	</div>
);

const Arrow = () => (
	<svg width="7" height="4" viewBox="0 0 7 4" fill="none" xmlns="http://www.w3.org/2000/svg">
		<g clipPath="url(#clip0)">
			<path
				d="M3.42997 2.65606L0.864111 0.109343C0.794425 0.0387543 0.699652 0 0.599303 0C0.498955 0 0.404181 0.0387543 0.334495 0.109343L0.110105 0.33218C0.0390244 0.401384 0 0.495502 0 0.595156C0 0.69481 0.0390244 0.788927 0.110105 0.858131L3.16376 3.89204C3.23484 3.96263 3.32962 4.00138 3.42997 4C3.53031 4 3.62509 3.96125 3.69617 3.89204L6.74704 0.8609C6.81812 0.790311 6.85714 0.697578 6.85714 0.597924C6.85714 0.49827 6.81812 0.404152 6.74704 0.334948L6.52265 0.112111C6.37631 -0.033218 6.13798 -0.033218 5.99164 0.112111L3.42997 2.65606Z"
				fill="#33879E"/>
		</g>
		<defs>
			<clipPath id="clip0">
				<rect width="6.85714" height="4" fill="white"/>
			</clipPath>
		</defs>
	</svg>
);
