import React from 'react';
import connect from '../../../jobs/context/connect';
import {ProcessConsumer} from "../context/ProcessController";
import PollingBox from "./PollingBox";
import ProgressMessage from "./ProgressMessage";
import Summary from "./Summary";
import Error from "./Error";

export const Main = ({process}) => (
	<div>
		{!!process.inProgress && <ProgressMessage/>}
		{!!process.finished && <Summary/>}
		{!!process.error && <Error/>}
		{!process.inProgress && <PollingBox/>}
	</div>
);

export default connect(Main, ProcessConsumer);