import React, {Component} from 'react';
import moment from 'moment';

const JobsContext = React.createContext({});

export class JobsProvider extends Component {

	constructor(props) {
		super(props);

		this.jobsAPI = props.jobsAPI;
		this.jobsLoader = props.jobsLoader;
		this.loadJobsOnMount = this.props.loadOnMount === true || this.props.loadOnMount === undefined;

		this.state = {
			jobs: [],
			lastPickupDate: null
		};
	}

	componentDidMount() {
		if (this.loadJobsOnMount) {
			this.loadJobs();
		}
	}

	async loadJobs() {
		this.jobsLoader.load().then(data => this.setState({
			jobs: data.jobs,
			lastPickupDate: data.last_picked_up_date
		}));
	}

	render() {
		const {children} = this.props;

		return (
			<JobsContext.Provider
				value={{
					...this.state,
					setJobs: jobs => this.setState({jobs}),
					refreshLastPickupDate: () => this.setState({lastPickupDate: moment()})
				}}
			>
				{children}
			</JobsContext.Provider>
		);
	}
}

export const JobsConsumer = JobsContext.Consumer;