/** globals WPML_TM_SETTINGS */

import React, {Component} from 'react';
import connect from '../../../jobs/context/connect';
import {JobsConsumer} from "./JobsProvider";
import {createHooks} from '@wordpress/hooks';
import UIChanges from '../../sync-translations-of-single-element/UIChanges';

import {isJobEqual} from "../../../jobs/model/jobs";

const ProcessContext = React.createContext({});

export class ProcessController extends Component {

	constructor(props) {
		super(props);

		this.initialState = {
			inProgress: false,
			finished: false,
			error: false,
			confirmationHidden: false,
			processedJobs: []
		};

		this.state = this.initialState;

	}

	async run() {
		this.setState({...this.initialState, inProgress: true});

		const hooks = this.defineHooks();

		try {
			await this.props.createProcess(hooks).run(this.props.jobs);
			this.setState({inProgress: false, finished: true});

			this.updateJobsIconOnTheList();
		} catch (error) {
			this.setState({inProgress: false, finished: false, error});
		}

		const remainingJobs = this.props.jobs.filter(
			job => this.state.processedJobs.find(processedJob => isJobEqual(job, processedJob)) === undefined
		);

		this.props.setJobs(remainingJobs);
		this.props.refreshLastPickupDate();
	}

	defineHooks() {
		const hooks = createHooks();

		hooks.addAction(
			'wpml-tm-job-translations-processed',
			'CheckAndDownloadTranslations',
			newProcessedJobs => this.setState(({processedJobs}) => ({processedJobs: processedJobs.concat(newProcessedJobs)}))
		);

		return hooks;
	}

	updateJobsIconOnTheList() {
		const uiChanges = new UIChanges(
			document,
			null,
			WPML_TM_SETTINGS.statusIcons
		);

		this.state.processedJobs.map(job => {
			uiChanges.updateIcon(job)
		});
	}

	render() {
		const {children} = this.props;

		return (
			<ProcessContext.Provider
				value={{
					process: {
						...this.state,
						run: () => this.run(),
						hideConfirmation: () => this.setState({confirmationHidden: true}),
					}
				}}
			>
				{children}
			</ProcessContext.Provider>
		);
	}
}

export const ProcessConsumer = ProcessContext.Consumer;

export default connect(ProcessController, JobsConsumer);