import {JOB_STATUSES} from "../../../jobs/model/jobs";

export class Worker {
	constructor(jobAPI, hooks) {
		this.LIMIT_PER_CHUNK = 5;
		this.REQUEST_NUM_LIMIT = 5;

		this.jobAPI = jobAPI;
		this.hooks = hooks
	}

	async download(jobs) {
		this.allJobsCount = jobs.length;
		this.alreadyProcessedJobs = 0;
		this.jobsToProcess = [...jobs];

		const requests = [];
		while (this.jobsToProcess.length && requests.length < this.REQUEST_NUM_LIMIT) {
			const chunk = this.getNextJobsSet();
			requests.push(this.downloadSubset(chunk));
		}

		await Promise.all(requests);

		return true;
	}

	async downloadSubset(jobsSet) {
		await this.jobAPI.applyTranslation(jobsSet);
		jobsSet = jobsSet.map(job => ({...job, status: JOB_STATUSES.COMPLETED}));

		this.alreadyProcessedJobs += jobsSet.length;
		this.hooks.doAction('wpml-tm-job-translations-processed', jobsSet);

		if (this.jobsToProcess.length > 0) {
			return this.downloadSubset(this.getNextJobsSet());
		}
	}

	getNextJobsSet() {
		const jobsSet = this.jobsToProcess.slice(0, this.LIMIT_PER_CHUNK);
		this.jobsToProcess.splice(0, this.LIMIT_PER_CHUNK);

		return jobsSet;
	}
}


export class DownloadTranslations {
	constructor(jobAPI, hooks) {
		this.jobAPI = jobAPI;
		this.hooks = hooks;
	}

	async download(jobs) {
		const worker = new Worker(this.jobAPI, this.hooks);
		return worker.download(jobs);
	}
}