import {JOB_STATUSES} from "../../../jobs/model/jobs";
import moment from 'moment';

export class JobsLoader {
	constructor(jobAPI) {
		this.jobAPI = jobAPI;
	}

	async load() {
		const params = {
			scope: 'remote',
			status: JOB_STATUSES.TRANSLATION_READY_TO_DOWNLOAD + ',' + JOB_STATUSES.IN_PROGRESS
		};

		try {
			const response = await this.jobAPI.loadJobs(params);

			return {
				jobs: response.jobs,
				last_picked_up_date: response.last_picked_up_date ? moment.unix(response.last_picked_up_date) : null
			}
		} catch (e) {
			return {
				jobs: [],
				last_picked_up_date: null
			};
		}
	}
}