class TranslationJobsMigration {

	constructor(ajaxUrl) {
		this.ajaxUrl = ajaxUrl;
		this.migrationTrigger = document.querySelector('.wpml-start-jobs-migration');
		this.results = document.querySelector('.wpml-js-jobs-migration-progress');
		this.jobsMigrated = document.querySelector('.wpml-js-migrated-jobs');
		this.jobsMigratedCount = 0;
		this.totalJobs = document.querySelector('.wpml-js-total-jobs');
		this.totalJobsCount = 0;
		this.spinner = document.querySelector('.wpml-jobs-migration-spinner');
		this.nonce = document.querySelector('#wpml_translation_jobs_migration').value;
	}

	attachEvents() {
		this.migrationTrigger.addEventListener('click', () => this.run());
	}

	run() {
		this.migrationTrigger.disabled = true;
		this.spinner.classList.add('is-active');
		this.migrate();
	}

	migrate() {
		fetch(this.ajaxUrl, {
			method: 'POST',
			headers: {
				'Content-Type': 'application/x-www-form-urlencoded; charset=utf-8'
			},
			body: `action=wpml_translation_jobs_migration&nonce=${this.nonce}`,
			credentials: 'same-origin'
		})
		.then(res => res.json())
		.then(res => {
			if (! res.success) {
				throw res;
			}

			this.results.style.display = 'block';
			this.jobsMigratedCount += res.data.jobsMigrated;
			this.updateResults(this.jobsMigratedCount);

			if (!this.totalJobsCount) {
				this.totalJobsCount = res.data.totalJobs;
				this.totalJobs.innerHTML = this.totalJobsCount;
			}

			if (res.data.done) {
				location.reload();
			} else {
				this.migrate();
			}
		}).catch(err => {
			const errorContainer = document.querySelector('.wpml-job-migration-error');
			if (errorContainer) {
				if (err.data) {
					errorContainer.querySelector('.error-message').textContent = err.data;
				}
				errorContainer.style.display = 'block';
			}
		});
	}

	updateResults(jobs) {
		this.jobsMigrated.innerHTML = jobs;
	}
}

export default TranslationJobsMigration;