import React from 'react';
import './style/index.scss';
import 'antd/lib/spin/style/index.css';
import ReviewModal from "./components/ReviewModal";
import ReviewTransparentModal from "./components/ReviewTransparentModal";
import InProgressText from "./components/InProgressText";
import ErrorText from "./components/ErrorText";
import AcceptedText from "./components/AcceptedText";
import PublishedText from "./components/PublishedText";
import PublishButton from "./components/PublishButton";
import BackButton from "./components/BackButton";
import EditButton from "./components/EditButton";
import AcceptedMessage from "./components/AcceptedMessage";
import useATESync from "./hooks/useATESync";
import usePreviousTranslationNotification from "./hooks/usePreviousTranslationNotification";
import useAcceptTranslation from "./hooks/useAcceptTranslation";
import {useStoreState} from "easy-peasy";
import {prop} from "ramda";


export default () => {
    const [isSyncing, hasError] = useATESync();
    const [previousTranslation] = usePreviousTranslationNotification();
    const [accepted, accept, inProgress] = useAcceptTranslation();
    const {backUrl, jobEditUrl, isPublished} = useStoreState(prop('generalData'));


    if (isSyncing) {
        return <ReviewTransparentModal><InProgressText/></ReviewTransparentModal>;
    }

    if (hasError) {
        return <ReviewModal><ErrorText/></ReviewModal>;
    }

    return <>
        {
            previousTranslation === 'accepted' &&
            <ReviewTransparentModal><AcceptedText/></ReviewTransparentModal>
        }
        {
            previousTranslation === 'published' &&
            <ReviewTransparentModal><PublishedText/></ReviewTransparentModal>
        }
        <div className={'wpml-review__box'}>
            {
                backUrl && <BackButton backUrl={backUrl}/>
            }
            <EditButton editUrl={jobEditUrl}/>
            {
                accepted && <AcceptedMessage/>
            }
            {
                !accepted && <PublishButton accept={accept} inProgress={inProgress} isPublished={isPublished}/>
            }
        </div>
    </>
};
